# YouTube Dubbing Chrome Extension

**By ToolWeb.in**

Dub YouTube videos in your preferred language using AI-powered translation and text-to-speech.

## Features

- 🌍 **16+ Languages** - Hindi, Tamil, Telugu, Spanish, French, German, Japanese, Korean, Chinese, and more
- 🎙️ **Natural Voices** - High-quality neural TTS voices (male/female options)
- ⚡ **Caption-Based** - Uses YouTube's captions for accurate timing
- 🎚️ **Adjustable Controls** - Speed control and original audio volume mixing
- 🎯 **Real-time Sync** - Audio syncs with video playback, seeking, and pausing

## Installation

### Chrome Extension

1. Open Chrome and go to `chrome://extensions/`
2. Enable **Developer mode** (toggle in top-right corner)
3. Click **Load unpacked**
4. Select the `youtube-dubbing-extension` folder
5. The extension icon should appear in your toolbar

### Backend API (Dubby Service)

The extension requires the FastAPI backend to be running on port **8161**.

**Quick Setup (as systemd service):**

```bash
cd youtube-dubbing-backend

# Make setup script executable
chmod +x setup.sh

# Run setup (installs service as "dubby")
sudo ./setup.sh
```

This will:
- Install to `/home/api.toolweb.in/public_html/dubby`
- Create Python virtual environment
- Install dependencies
- Configure systemd service
- Start the service on port 8161

**Manual Setup:**

```bash
cd youtube-dubbing-backend

# Create virtual environment
python3 -m venv venv
source venv/bin/activate

# Install dependencies
pip install -r requirements.txt

# Run the server
uvicorn main:app --host 0.0.0.0 --port 8161
```

**Service Management:**

```bash
sudo systemctl status dubby     # Check status
sudo systemctl restart dubby    # Restart
sudo systemctl stop dubby       # Stop
sudo journalctl -u dubby -f     # View logs
```

**Nginx Configuration:**

Add the contents of `nginx-dubby.conf` to your api.mkkpro.com server block to route `/youtube-dubbing/*` to port 8161.

## Usage

1. Navigate to any YouTube video
2. Click the extension icon in your toolbar
3. Select your target language
4. Adjust voice settings (gender, speed, original volume)
5. Click **Start Dubbing**
6. Wait for processing (typically 10-30 seconds depending on video length)
7. Enjoy the dubbed audio!

## How It Works

```
┌─────────────┐     ┌─────────────┐     ┌─────────────┐
│   YouTube   │────▶│  Extension  │────▶│  FastAPI    │
│   Video     │     │  (Chrome)   │     │  Backend    │
└─────────────┘     └─────────────┘     └─────────────┘
                           │                   │
                           │            ┌──────┴──────┐
                           │            │             │
                           │      ┌─────▼─────┐ ┌─────▼─────┐
                           │      │ Translate │ │    TTS    │
                           │      │  (Google) │ │ (Edge-TTS)│
                           │      └───────────┘ └───────────┘
                           │
                    ┌──────▼──────┐
                    │ Audio Sync  │
                    │  Playback   │
                    └─────────────┘
```

1. **Caption Extraction** - Fetches YouTube captions (auto-generated or manual)
2. **Translation** - Translates text to target language using Google Translate
3. **TTS Generation** - Generates audio using Microsoft Edge TTS (free, high-quality)
4. **Sync Playback** - Plays dubbed audio synced with video timeline

## API Endpoints

| Endpoint | Method | Description |
|----------|--------|-------------|
| `/youtube-dubbing/start` | POST | Start a dubbing job |
| `/youtube-dubbing/status/{job_id}` | GET | Check job progress |
| `/youtube-dubbing/cancel/{job_id}` | POST | Cancel a job |
| `/youtube-dubbing/audio/{filename}` | GET | Serve audio files |
| `/youtube-dubbing/health` | GET | Health check |

## Supported Languages

| Code | Language |
|------|----------|
| en | English |
| hi | Hindi |
| ta | Tamil |
| te | Telugu |
| es | Spanish |
| fr | French |
| de | German |
| ja | Japanese |
| ko | Korean |
| zh | Chinese |
| pt | Portuguese |
| ru | Russian |
| ar | Arabic |
| it | Italian |
| nl | Dutch |
| tr | Turkish |

## Configuration

### Extension Settings (stored in Chrome)
- `targetLanguage` - Default language for dubbing
- `voiceGender` - Preferred voice (male/female)
- `voiceSpeed` - Playback speed (0.5x - 2x)
- `originalVolume` - Original audio volume (0-100%)

### Backend Configuration
Edit `main.py` to configure:
- `AUDIO_OUTPUT_DIR` - Where generated audio files are stored
- `CACHE_DIR` - Cache directory for optimization
- `VOICE_MAP` - Voice mappings for each language

## Limitations

- Requires YouTube video to have captions (auto-generated works)
- Processing time depends on video length
- Audio quality depends on TTS service
- Some timing sync issues may occur with fast-paced speech

## Troubleshooting

**"No captions available"**
- The video doesn't have captions enabled
- Try a different video with CC available

**"Failed to connect to server"**
- Ensure the backend API is running
- Check your network connection
- Verify the API_BASE_URL in the extension

**Audio out of sync**
- Adjust the speed slider
- Some videos have inherently difficult timing

## Tech Stack

**Extension:**
- Manifest V3
- Chrome APIs (tabs, storage, runtime)
- Web Audio API for playback

**Backend:**
- FastAPI (Python)
- youtube-transcript-api
- deep-translator
- edge-tts

## License

© 2024 ToolWeb.in - All rights reserved.

## Support

For issues or feature requests, visit [ToolWeb.in](https://toolweb.in)
